<?php include 'header.php'; ?>

<main class="site-main">

  <section class="section" style="padding-bottom: 5px;">
    <div class="container">

      <h2><i class="fa-solid fa-table-cells icon"></i>Examples</h2>

      <p style="margin-bottom: 0;">
        A visual showcase of layout patterns used in this template. You can use these or play around with it as much as
        you want.
      </p>
    </div>
  </section>

  <!-- ================= 1) SINGLE BOX ================= -->

  <section class="section">
    <div class="container">

      <h3>1) Single Box</h3>

      <p>
        <i class="fa-solid fa-caret-right icon"></i>
        A single Box placed directly inside the container.
        This automatically becomes a full-width box.
      </p>

      <div class="box">
        Single full-width Box
      </div>
    </div>
  </section>

  <!-- ================= 2) 2-BOX GRID ================= -->

  <section class="section">
    <div class="container">

      <h3>2) 2-Box Grid</h3>

      <p>
        <i class="fa-solid fa-caret-right icon"></i>
        Boxes placed inside <code>.grid.grid-2</code> are displayed
        in two columns on larger screens and stack on mobile.
      </p>

      <div class="grid grid-2">
        <div class="box">Box Left</div>
        <div class="box">Box Right</div>
      </div>
    </div>
  </section>

  <!-- ================= 3) 3-BOX GRID ================= -->

  <section class="section">
    <div class="container">

      <h3>3) 3-Box Grid</h3>

      <p>
        <i class="fa-solid fa-caret-right icon"></i>
        Boxes inside <code>.grid</code> are shown in three columns
        on larger screens and stack automatically on smaller ones.
      </p>

      <div class="grid">
        <div class="box">Box A</div>
        <div class="box">Box B</div>
        <div class="box">Box C</div>
      </div>
    </div>
  </section>

  <!-- ================= 4) COMBINED EXAMPLE ================= -->

  <section class="section">
    <div class="container">

      <h3>4) Combined</h3>

      <p>
        <i class="fa-solid fa-caret-right icon"></i>
        This example combines a single Box with grid-based layouts.
      </p>

      <div class="box" style="margin-bottom:16px;">
        Single full-width Box
      </div>

      <div class="grid grid-2" style="margin-bottom:16px;">
        <div class="box">Grid Box 1</div>
        <div class="box">Grid Box 2</div>
      </div>

      <div class="grid">
        <div class="box">Grid Box A</div>
        <div class="box">Grid Box B</div>
        <div class="box">Grid Box C</div>
      </div>
    </div>
  </section>

</main>

<?php include 'footer.php'; ?>